% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/toLower.R
\name{toLower}
\alias{toLower}
\alias{toLower.NULL}
\alias{toLower.character}
\alias{toLower.corpus}
\alias{toLower.tokenizedTexts}
\title{Convert texts to lower case}
\usage{
toLower(x, keepAcronyms = FALSE, ...)

\method{toLower}{character}(x, keepAcronyms = FALSE, ...)

\method{toLower}{NULL}(x, ...)

\method{toLower}{tokenizedTexts}(x, keepAcronyms = FALSE, ...)

\method{toLower}{corpus}(x, keepAcronyms = FALSE, ...)
}
\arguments{
\item{x}{texts to be lower-cased}

\item{keepAcronyms}{if \code{TRUE}, do not lowercase any all-uppercase words}

\item{...}{additional arguments passed to \pkg{stringi} functions, (e.g.
\code{\link{stri_trans_tolower}}), such as \code{locale}}
}
\value{
Texts tranformed into their lowercased versions.  If \code{x} is a
  character vector or a corpus, return a lowercased character vector.  If
  \code{x} is a list of tokenized texts, then return a list of lower-cased
  tokenized texts.
}
\description{
Convert texts or tokens to lower case
}
\examples{
test1 <- c(text1 = "England and France are members of NATO and UNESCO",
           text2 = "NASA sent a rocket into space.")
toLower(test1)
toLower(test1, keepAcronyms = TRUE)

test2 <- tokenize(test1, removePunct=TRUE)
toLower(test2)
toLower(test2, keepAcronyms = TRUE)
}

