% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R, R/dfm-methods.R
\name{sample}
\alias{sample}
\alias{sample.corpus}
\alias{sample.default}
\alias{sample.dfm}
\title{Randomly sample documents or features}
\usage{
sample(x, size, replace = FALSE, prob = NULL, ...)

\method{sample}{default}(x, size, replace = FALSE, prob = NULL, ...)

\method{sample}{corpus}(x, size = ndoc(x), replace = FALSE, prob = NULL,
  ...)

\method{sample}{dfm}(x, size = ndoc(x), replace = FALSE, prob = NULL,
  what = c("documents", "features"), ...)
}
\arguments{
\item{x}{a corpus or dfm object whose documents or features will be sampled}

\item{size}{a positive number, the number of documents to select}

\item{replace}{Should sampling be with replacement?}

\item{prob}{A vector of probability weights for obtaining the elements of the
vector being sampled.}

\item{...}{unused
\code{\link[base]{sample}}, which is not defined as a generic
method in the \pkg{base} package.}

\item{what}{dimension (of a \link{dfm}) to sample: can be \code{documents} or
\code{features}}
}
\value{
A corpus object with number of documents equal to \code{size}, drawn 
  from the corpus \code{x}.  The returned corpus object will contain all of 
  the meta-data of the original corpus, and the same document variables for 
  the documents selected.

A dfm object with number of documents equal to \code{size}, drawn 
  from the corpus \code{x}.  The returned corpus object will contain all of 
  the meta-data of the original corpus, and the same document variables for 
  the documents selected.
}
\description{
Takes a random sample or documents or features of the specified size from a 
corpus or document-feature matrix, with or without replacement
}
\examples{
# sampling from a corpus
summary(sample(inaugCorpus, 5)) 
summary(sample(inaugCorpus, 10, replace=TRUE))
# sampling from a dfm
myDfm <- dfm(inaugTexts[1:10], verbose = FALSE)
sample(myDfm)[, 1:10]
sample(myDfm, replace = TRUE)[, 1:10]
sample(myDfm, what = "features")[1:10, ]
}
\seealso{
\code{\link{sample}}
}

