% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability.R
\name{scrabble}
\alias{scrabble}
\alias{scrabble.character}
\title{compute the Scrabble letter values of text}
\usage{
scrabble(x, FUN = sum)

\method{scrabble}{character}(x, FUN = sum)
}
\arguments{
\item{x}{a character vector}

\item{FUN}{function to be applied to the character values in the text; 
default is \code{sum}, but could also be \code{mean} or a user-supplied 
function}
}
\value{
a vector of Scabble letter values, computed using \code{FUN}, 
  corresponding to the input text(s)
}
\description{
Compute the Scrabble letter values of text given a user-supplied function, 
such as the sum (default) or mean of the character values.
}
\note{
Character values are only defined for non-accented Latin a-z, A-Z 
  letters.  Lower-casing is unnecessary.
}
\examples{
scrabble(c("muzjiks", "excellency"))
scrabble(inaugTexts[1:5], mean)
}
\author{
Kenneth Benoit
}

