% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_wordscores.R
\name{predict.textmodel_wordscores}
\alias{predict.textmodel_wordscores}
\title{Predict textmodel_wordscores}
\usage{
\method{predict}{textmodel_wordscores}(object, newdata = NULL,
  se.fit = FALSE, interval = c("none", "confidence"), level = 0.95,
  rescaling = c("none", "lbg", "mv"), force = FALSE, ...)
}
\arguments{
\item{object}{a fitted Wordscores textmodel}

\item{newdata}{dfm on which prediction should be made}

\item{se.fit}{if \code{TRUE}, return standard errors as well}

\item{interval}{type of confidence interval calculation}

\item{level}{tolerance/confidence level for intervals}

\item{rescaling}{\code{"none"} for "raw" scores; \code{"lbg"} for LBG (2003) 
rescaling; or \code{"mv"} for the rescaling proposed by Martin and Vanberg 
(2007).  See References.}

\item{force}{make newdata's feature set conformant to the model terms}

\item{...}{not used}
}
\value{
\code{predict.textmodel_wordscores()} returns a named vector of predicted
document scores ("text scores" \eqn{S_{vd}} in LBG 2003), or a named list if
\code{se.fit = TRUE} consisting of the predicted scores (\code{$fit}) and the
associated standard errors (\code{$se.fit}). When \code{interval =
"confidence"}, the predicted values will be a matrix.  This behaviour matches
that of \code{\link[stats]{predict.lm}}.
}
\description{
Predict textmodel_wordscores
}
\examples{
ws <- textmodel_wordscores(data_dfm_lbgexample, c(seq(-1.5, 1.5, .75), NA))
predict(ws)
predict(ws, rescaling = "mv")
predict(ws, rescaling = "lbg")
predict(ws, se.fit = TRUE)
predict(ws, se.fit = TRUE, interval = "confidence")
predict(ws, se.fit = TRUE, interval = "confidence", rescaling = "lbg")
}
\keyword{internal}
\keyword{textmodel}
