% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_group.R
\name{dfm_group}
\alias{dfm_group}
\title{Combine documents in a dfm by a grouping variable}
\usage{
dfm_group(x, groups = NULL, fill = FALSE)
}
\arguments{
\item{x}{a \link{dfm}}

\item{groups}{either: a character vector containing the names of document 
variables to be used for grouping; or a factor or object that can be 
coerced into a factor equal in length or rows to the number of documents. 
See \link{groups} for details.}

\item{fill}{logical; if \code{TRUE} and \code{groups} is a factor, then use
all levels of the factor when forming the new "documents" of the grouped
dfm.  This will result in documents with zero feature counts for levels not
observed.  Has no effect if the \code{groups} variable(s) are not factors.}
}
\value{
\code{dfm_group} returns a \link{dfm} whose documents are equal to
  the unique group combinations, and whose cell values are the sums of the
  previous values summed by group. Document-level variables that have no
  variation within groups are saved in \link{docvars}.

  Setting the \code{fill = TRUE} offers a way to "pad" a dfm with document
  groups that may not have been observed, but for which an empty document is
  needed, for various reasons.  If \code{groups} is a factor of dates, for
  instance, then using \code{fill = TRUE} ensures that the new documents will
  consist of one row of the dfm per date, regardless of whether any documents
  previously existed with that date.
}
\description{
Combine documents in a \link{dfm} by a grouping variable, which can also be
one of the \link{docvars} attached to the dfm. This is identical in
functionality to using the \code{"groups"} argument in \code{\link{dfm}}.
}
\examples{
mycorpus <- corpus(c("a a b", "a b c c", "a c d d", "a c c d"),
                   docvars = data.frame(grp = c("grp1", "grp1", "grp2", "grp2")))
mydfm <- dfm(mycorpus)
dfm_group(mydfm, groups = "grp")
dfm_group(mydfm, groups = c(1, 1, 2, 2))

# equivalent
dfm(mydfm, groups = "grp")
dfm(mydfm, groups = c(1, 1, 2, 2))
}
