% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.partial.sb.R
\name{crossq.partial.sb}
\alias{crossq.partial.sb}
\title{Stationary Bootstrap for the Partial Cross-Quantilogram}
\usage{
crossq.partial.sb(DATA, vecA, k, gamma, Bsize, sigLev)
}
\arguments{
\item{DATA}{The original data matrix}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{k}{A lag order}

\item{gamma}{A parameter for the stationary bootstrap}

\item{Bsize}{The number of repetition of bootstrap}

\item{sigLev}{The statistical significance level}
}
\value{
The boostrap critical values
}
\description{
Returns critical values for the partial cross-quantilogram, based on the stationary bootstrap.
}
\details{
This function generates critical values for for the partial cross-quantilogram,
using the stationary bootstrap in Politis and Romano (1994).
}
\references{
Politis, Dimitris N., and Joseph P. Romano. "The stationary bootstrap." \emph{Journal of the American Statistical Association} 89.428 (1994): 1303-1313.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
