% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-QuantileSD.R
\name{QuantileSD-constructor}
\alias{QuantileSD-constructor}
\alias{quantileSD}
\title{Create an instance of the \code{\link{QuantileSD}} class.}
\usage{
quantileSD(N = 2^8, type = c("copula", "Laplace"), ts = rnorm,
  seed.init = runif(1), levels.1, levels.2 = levels.1, R = 1,
  quiet = FALSE)
}
\arguments{
\item{N}{the number of Fourier frequencies to be used.}

\item{type}{can be either \code{Laplace} or \code{copula}; indicates whether
the marginals are to be assumed uniform \eqn{[0,1]} distributed.}

\item{ts}{a function that has one argument \code{n} and, each time it is
invoked, returns a new time series from the model for which the
copula spectral density kernel is to be simulated.}

\item{seed.init}{an integer serving as an initial seed for the simulations.}

\item{levels.1}{A vector of length \code{K1} containing the levels \code{x1}
at which the \code{QuantileSD} is to be determined.}

\item{levels.2}{A vector of length \code{K2} containing the levels \code{x2}
at which the \code{QuantileSD} is to be determined.}

\item{R}{an integer that determines the number of independent simulations;
the larger this number the more precise is the result.}

\item{quiet}{Dont't report progress to console when computing the \code{R}
              independent quantile periodograms.}
}
\value{
Returns an instance of \code{QuantileSD}.
}
\description{
Create an instance of the \code{\link{QuantileSD}} class.
}
\seealso{
For examples see \code{\link{QuantileSD}}.
}
\keyword{Constructors}

