% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-FreqRep.R
\docType{methods}
\name{plot-FreqRep}
\alias{plot,FreqRep,ANY-method}
\alias{plot-FreqRep}
\title{Plot the values of the \code{\link{FreqRep}}.}
\usage{
\S4method{plot}{FreqRep,ANY}(x, ratio = 2, frequencies = 2 * pi *
  (1:(floor(length(x@Y)/2)))/length(x@Y), levels = x@levels)
}
\arguments{
\item{x}{The \code{\link{FreqRep}} to plot.}

\item{ratio}{quotient of width over height of the subplots; use this
parameter to produce landscape or portrait shaped plots.}

\item{frequencies}{a set of frequencies for which the values are to be
plotted.}

\item{levels}{a set of levels for which the values are to be plotted.}
}
\value{
Plots the \code{\link{FreqRep}} for all
         \code{frequencies} and \code{levels} specified.
}
\description{
Creates a \code{K} x \code{2} plot depicting a
\code{\link{FreqRep}} object.
Each of the \code{K} ``lines'' of subplots shows the frequency representation
for one value of \eqn{\tau}{tau}. The real and imaginary part are shown on
the left and the right, respectively.
}

