% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/not.duplicated.R
\name{not.duplicated}
\alias{not.duplicated}
\title{Not duplicated elements}
\usage{
not.duplicated(x, incomparables = FALSE, ...)
}
\arguments{
\item{x}{a vector or a data frame or an array or NULL.}

\item{incomparables}{a vector of values that cannot be compared. FALSE is a special value, meaning that all values can be compared, and may be the only value accepted for methods other than the default. It will be coerced internally to the same type as x}

\item{...}{arguments for particular methods.}
}
\value{
elements of a vector or data frame that are NOT duplicates
}
\description{
Checks which elements of a vector or data frame are NOT duplicates of elements with smaller subscripts
}
\examples{

set.seed(08082023)
dtf <- sample(1:10,15, replace = TRUE)
dtf # 3  9 10  3  8  9  6 10  5  1  2  2  2  9  8
dtf[ dtf > 4 & not.duplicated(dtf) ] # 9 10  8  6  5

}
