% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{extract_comment}
\alias{extract_comment}
\alias{remove_content_in_quotes}
\alias{remove_comment}
\alias{clean_file}
\alias{get_func_def}
\title{Extract all comments or functions from a file}
\usage{
extract_comment(file)

remove_content_in_quotes(line)

remove_comment(line)

clean_file(file, output_file)

get_func_def(file)
}
\arguments{
\item{file}{file to parse}

\item{line}{string vector to remove contents within quotes or comments}

\item{output_file}{file path to write the output of the new file}
}
\value{
vector of all comments within a file
}
\description{
Vectorize all comments from the file
}
\examples{
\dontrun{
ex_file1 <- "path/file1.R"
# get all comments
cmmts <- extract_comment(ex_file1)
cmmts
}

\dontrun{
# Ex to clean out comments from file
file_path <- ".testR"
output_file_path <- ".cleaned_script.R"
clean_file(file_path, output_file_path)
}

# example code

\dontrun{
# Ex to get all defined functions
# within a file
file_path <- ".testR"
get_func_def(file_path)
}
}
