% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/not.inherits.R
\name{not.inherits}
\alias{not.inherits}
\title{Not inherit from any of the classes specified}
\usage{
not.inherits(x, what, which = FALSE)
}
\arguments{
\item{x}{a \R object}

\item{what}{a character vector naming classes.}

\item{which}{logical affecting return value: see \sQuote{Details}.}
}
\value{
a boolean value to indicate if !inherits
}
\description{
Opposite of base::inherits().
Indicates whether its first argument inherits from any of the classes specified in the what argument. If which is TRUE then an integer vector of the same length as what is returned. Each element indicates the position in the class(x) matched by the element of what; zero indicates no match. If which is FALSE then TRUE is returned by inherits if any of the names in what match with any class.
}
\examples{
keep.cols = "a character"
class(keep.cols) # class is character
not.inherits(keep.cols,"character")

num.var = 1L
class(num.var) # class is integer
not.inherits(num.var,"double")

}
