% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_compHist.R
\name{compHist}
\alias{compHist}
\title{Compare histograms of two distributions}
\usage{
compHist(
  x1,
  x2,
  title,
  col1 = "red",
  col2 = "yellow",
  xlab = "",
  ylab = "Frequency",
  separate = FALSE
)
}
\arguments{
\item{x1}{NUMERIC. the first distribution}

\item{x2}{NUMERIC. the second distribution}

\item{title}{CHARACTER. title of the histogram plot}

\item{col1}{CHARACTER. color fill for first distribution}

\item{col2}{CHARACTER. color fill for second distribution}

\item{xlab}{CHARACTER. label of the x-axis}

\item{ylab}{CHARACTER. label of the y-axis}

\item{separate}{LOGICAL. whether to separate the plots}
}
\value{
return histogram comparison using basic histogram plot
}
\description{
For comparing histograms of two data distributions.
Simply input the two distributions, and it generates a clear and
informative histogram that illustrates the differences between the data.
}
\details{
Users have the option to view individual histograms for each distribution
before initiating the comparison, allowing for a detailed examination of
each dataset's characteristics. This feature ensures a comprehensive
understanding of the data and enhances the user's ability to interpret
the results of the distribution comparison provided by this function.
}
\note{
- Hexadecimal values can also be passed \cr
  in for col1 and col2, see the example section
- For best visual results, \cr
  col1 should be a dark color and col2 should be passed as a light color. \cr
  For example, col1 = "black", col2 = "yellow"
}
\section{Some recommended color pairs}{

col1 = 'dodgerblue4' (and) col2 = 'darksalmon' \cr
col1 = 'brown' (and) col2 = 'beige' \cr
col1 = 'pink' (and) col2 = 'royalblue4' \cr
col1 = 'red' (and) col2 = 'yellow' \cr
col1 = 'limegreen' (and) col2 = 'blue' \cr
col1 = 'darkred' (and) col2 = 'aquamarine4' \cr
col1 = 'purple' (and) col2 = 'yellow' \cr
}

\examples{
# compare two normal distributions with means that differ a lot
# in this case, the overlap will not be observed
set.seed(123)
compHist(
  x1 = rnorm(1000, mean = 3),
  x2 = rnorm(1000, mean = 10),
  title = "Histogram of Distributions With Means 3 & 10",
  col1 = "yellow", col2 = "violet"
)


# compare two normal distributions with means that are close
# in this case, the overlap between the histograms will be observed
set.seed(123)
compHist(
  x1 = rnorm(1000, mean = 0),
  x2 = rnorm(1000, mean = 2),
  title = "Histogram of rnorm Distributions With Means 0 & 2",
  col1 = "lightslateblue", col2 = "salmon"
)

set.seed(123)
# separate the plots for preview
compHist(
  x1 = rnorm(1000, mean = 0),
  x2 = rnorm(1000, mean = 2),
  title = c("Plot Means 0", "Plot Means 2"),
  col1 = "#F96167", col2 = "#CCF381",
  separate = TRUE
)

}
