% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_desc_asc.R
\name{is.increasing}
\alias{is.increasing}
\alias{is.decreasing}
\title{Check is numbers in a vector are decreasing or increasing}
\usage{
is.increasing(., na.last = TRUE)

is.decreasing(., na.last = TRUE)
}
\arguments{
\item{.}{a numeric vector}

\item{na.last}{for controlling the treatment of NAs. If TRUE, missing values in the data are put last; if FALSE, they are put first; if NA, they are removed.}
}
\value{
boolean value to indicate if the values are increasing or decreasing
}
\description{
Test if numeric values of a vector are decreasing or increasing using the radix method
}
\examples{
# example code
doy1 <- rnorm(1e3)
doy2 <- sort(doy1, decreasing = FALSE)
doy3 <- sort(doy1, decreasing = TRUE)

is.increasing(doy1)
is.decreasing(doy1)

is.increasing(doy2)
is.decreasing(doy2)

is.increasing(doy3)
is.decreasing(doy3)
}
