% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/i.R
\name{i}
\alias{i}
\title{Identify}
\usage{
i(qmap_obj = NULL, i_idx = 1, loc = NULL)
}
\arguments{
\item{qmap_obj}{a \code{qmap} object from which to identify features.
An \code{sp} object may also be passed directly}

\item{i_idx}{a numeric value specifying which data layer to identify or a
character string indicating the name of the layer. Defaults to 1.}

\item{loc}{A list with an x and y numeric indicating a location.  Default is
to interactively get loc value until escaped.}
}
\value{
Returns a list that contains data for the selected object (data is
         NULL if not a Spatial DataFrame object), the \code{sp} object, and
         additional information for each object (e.g. area and perimeter for
         polygons).
}
\description{
Interactively select an \code{sp} or \code{raster} object and return the
data associated with it. \code{i()} only accepts a single input point.
}
\examples{
\dontrun{
data(lake)
qm<-qmap(list(lake,elev,samples))
i(qm,"lake")
i(qm,"samples")
i(qm,2)
}
}

