% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_mle.R
\name{frame_mle}
\alias{frame_mle}
\title{General Cook's distance or Q-function distance of quantile regression}
\usage{
frame_mle(y, x, tau, error = 1e-06, iter = 100,
  method = c("cook.distance", "qfunction"))
}
\arguments{
\item{y}{vector, dependent variable for quantile regression}

\item{x}{matrix, design matrix for quantile regression. For quantile regression
model with intercept, the firt column of x is 1.}

\item{tau}{sigular or vector, quantiles}

\item{error}{the EM algorithm accuracy of error used in MLE estimation}

\item{iter}{the iteration frequancy for EM algorithm used in MLE estimation}

\item{method}{use method 'cook.distance' or 'qfunction'}
}
\value{
generalized Cook's distance or Q-function distance for
multiple quantiles
}
\description{
dataframe used to plot generalized Cook's distance or
Q-function distance for observations.
}
\details{
Gerneralized Cook's distance and Q-function distance are commonly used in
detecting the influence data point when performing regression
analysis. They involve the log-likelihood function and estimations of
based on the complete and case-deletion data. We used EM algorithm to
estimate the coefficiences of quantile regression with asymmetric Laplace
distribution.
}
\examples{
library(ggplot2)
data(ais)
ais_female <- subset(ais, Sex == 1)
y <- ais_female$BMI
x <- cbind(1, ais_female$LBM, ais_female$Bfat)
tau <- c(0.1, 0.5, 0.9)
case <- rep(1:length(y), length(tau))
GCD <- frame_mle(y, x, tau, error = 1e-06, iter = 10000,
                 method = 'cook.distance')
GCD_m <- cbind(case, GCD)
ggplot(GCD_m, aes(x = case, y = value )) +
  geom_point() +
  facet_wrap(~variable, scale = 'free') +
  geom_text(data = subset(GCD_m, value > mean(value) + 2*sd(value)),
            aes(label = case), hjust = 0, vjust = 0) +
  xlab("case number") +
  ylab("Generalized Cook Distance")

QD <- frame_mle(y, x, tau, error = 1e-06, iter = 10000,
                method = 'qfunction')
QD_m <- cbind(case, QD)
ggplot(QD_m, aes(x = case, y = value)) +
  geom_point() +
  facet_wrap(~variable, scale = 'free')+
  geom_text(data = subset(QD_m, value > mean(value) + sd(value)),
            aes(label = case), hjust = 0, vjust = 0) +
  xlab('case number') +
  ylab('Qfunction Distance')

}
\author{
Wenjing Wang\href{mailto:wenjingwangr@gmail.com}{wenjingwangr@gmail.com}
}
