% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_trimesh.R
\name{geom_trimesh}
\alias{geom_trimesh}
\title{Create a trimesh plot}
\usage{
geom_trimesh(
  mapping = NULL,
  data = NULL,
  stat = "trimesh",
  position = "identity",
  show.legend = NA,
  na.rm = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Aesthetic mappings for the plot.}

\item{data}{The data to be plotted.}

\item{stat}{The statistical transformation to be applied.}

\item{position}{The position adjustment to be applied.}

\item{show.legend}{Whether to show the legend for this layer.}

\item{na.rm}{Whether to remove missing values.}

\item{inherit.aes}{Whether to inherit aesthetics from the plot or the layer.}

\item{...}{Additional arguments to be passed to the `layer` function.}
}
\value{
A `ggplot2` layer object.
}
\description{
Create a trimesh plot
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
df_bin_centroids <- extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
ggplot2::ggplot() +
geom_trimesh(data = df_bin_centroids, mapping = ggplot2::aes(x = c_x, y = c_y))

}
