% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{tri_bin_centroids}
\alias{tri_bin_centroids}
\title{Triangulate bin centroids}
\usage{
tri_bin_centroids(hex_df, x, y)
}
\arguments{
\item{hex_df}{The data frame containing the bin centroids.}

\item{x}{The name of the column that contains x coordinates of bin centroids.}

\item{y}{The name of the column that contains y coordinates of bin centroids.}
}
\value{
A triangular object representing the triangulated bin centroids.
}
\description{
This function triangulates the bin centroids using the x and y coordinates
provided in the input data frame and returns the triangular object.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
df_bin_centroids <- extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
tri_bin_centroids(hex_df = df_bin_centroids, x = "c_x", y = "c_y")

}
