% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_checks.R
\name{pkg_check}
\alias{pkg_check}
\title{Package Checks}
\usage{
pkg_check(pkgs, versions, stop = FALSE)
}
\arguments{
\item{pkgs}{a character vector of package names to check for}

\item{versions}{an optional character vector, of the same length of
\code{pkgs} for the minimum version of the packages.}

\item{stop}{if \code{TRUE} then an error is thrown if any of the checks fail.
If \code{FALSE} (default) a logical is returned.}
}
\description{
Check if a package is available on the local machine and optionally verify a
version.
}
\details{
When writing a script that will be shared it is very likely that the multiple
authors/users will need to have a certain set of packages available to load.
The \code{pkg_check} function will verify that the packages are available to
load, this includes an optional version test, and attach the package to the
search list if requested.

Testing for package versions will is done as \code{packageVersion(x) >=
version}.  If you need a specific version of a package you should explicitly
use \code{packageVersion(x) == version} in your script.
}
