% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_bridge.R
\docType{data}
\name{isic_classification}
\alias{isic_classification}
\title{Dataset to bridge (translate) common sector-classification codes}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 768 rows and 4 columns.
}
\usage{
isic_classification
}
\description{
These dataset serve as a translation key between common sector-classification
systems and sectors relevant to the 'PACTA' tool
(\url{https://2degrees-investing.org/resource/pacta/}).
}
\section{Definitions}{

\itemize{
\item \code{borderline} (logical): Flag indicating if 2dii sector and classification code are a borderline match.
\item \code{code} (character): Original ISIC code.
\item \code{code_level} (double): Level of granularity of ISIC code.
\item \code{sector} (character): Associated 2dii sector.
}
}

\section{Details}{

Classification datasets help to standardize sector classification codes from
the wild to a relevant subset including 'power', 'oil and gas', 'coal',
'automotive', 'aviation', 'concrete', 'steel', and 'shipping'.
}

\examples{
head(isic_classification)
}
\seealso{
\link{data_dictionary}.

Other datasets for bridging sector classification codes: 
\code{\link{nace_classification}},
\code{\link{naics_classification}},
\code{\link{sector_classifications}}
}
\concept{datasets for bridging sector classification codes}
\keyword{datasets}
