\name{rthu}
\alias{rthu}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{~ Function: R to HTML, Univariate analysis ~}
\description{
  \code{rthu} performs some basic analyses, then generates 
  code to be included in a HTML document.
}

\usage{
  rthu(x,fileOut="",textBefore="",textAfter="",graphDir="graphUniv",graphName="V",type="png",limDiscrete=10)
}

\arguments{
  \item{x}{\code{[data.frame]} or \code{[vector]} : contains the
    data to analyse.}

  \item{fileOut}{\code{[character]};
    name of the output file in which
    the HTML summary will be saved. If empty, the HTML code is printed on screen.}

  \item{textBefore}{\code{[character] or [vector(character)]} : before
    printing a variable analysis, \code{rthu} can write a
    text. If \code{rthu} is applied on a single variable,
    \code{textBefore} should be of length 1. If \code{rthu} is applied on a \code{data.frame},
    \code{textBefore} can have same length as the number of columns of the \code{data.frame} (this lets
    the user write a specific introduction for each variable), or can be
    of length 1. In this case, it is printed before each variable
    analysis. See examples for details.}

  \item{textAfter}{\code{[character] or [vector(character)]} : after
    printing a variable analysis, \code{rthu} can write a
    text. If \code{rthu} is applied on a single variable,
    \code{textAfter} should be of length 1. If \code{rthu} is applied on a \code{data.frame},
    \code{textAfter} can have same length as the number of columns of the \code{data.frame} (this lets
    the user write a specific conclusion for each variable), or can be
    of length 1. In this case, it is printed after each variable
    analysis. See examples for details.}

  \item{graphDir}{\code{[character]} :
    directory used to save the graphs generated by the analyses.}

  \item{graphName}{\code{[character]} or \code{[vector(character)]} :
    prefix for the graph names. If empty, the graph names are
    \code{'V1'} to \code{'V'length(data.frame)}}

  \item{type}{\code{[character]} : type of plotting device used to export the
          graphics. Can be Windows metafile, PNG, JPEG, BMP (Windows bitmap format), TIFF,
          PostScript or PDF.}% See \link[grDevices]{savePlot} for details.}

  \item{limDiscrete}{\code{rthu} distinguishes two kinds of \code{numeric} :
    \code{discrete} designates \code{numeric} variables with only a few
    modalities,  \code{continuous} designates \code{numeric} variables with many
    modalities. The limit between 'few' and 'many' can be fixed by the
    user through the argument \code{limDiscrete}. By setting
    \code{limDiscrete} to 5, the user will ask \code{rthu} to consider
    all the \code{numeric} variables with more than 5 modalities as
    \code{continuous} and all the variables with less than 5 modalities
    as \code{discrete}.

    The default value for \code{limDiscrete} is 10.}
}

\details{
  \code{rthu} performs some basic analyses, then generates
  code to be included in a HTML document.

  \code{rthu} performs the analyses automatically according to the
  \code{data} class. It considers 4 classes. The analysis of the
  variable depends on the class:
  \enumerate{
    \item factor, character and logical: Frequency ; Graph: barplot
    \item ordered: Frequency, quartile ; Graph: barplot
    \item numeric discrete: Frequency, mean, variance, quartile ; Graph: boxplot and barplot
    \item numeric continuous: Mean, variance, quartile ; Graph: boxplot and histogram.
  }

  On a \code{data.frame}, \code{rthu} runs the analyses on every column.
}

\value{
  \code{rthu} generates HTML code and either prints it on the screen, or saves it in a
  file. It also generates several graphs, optionally in a different directory.
}

\section{Classical usage}{
  The use of \code{rthu} goes through the following steps:
  \tabular{ll}{
    Step 1. \tab Load the data (usually, a \code{data.frame}).\cr
    Step 2. \tab Optionally, set some variables as \code{ordered}. \cr
    Step 3. \tab Run \code{rthu(dataFrame,"fileOut.html")}.\cr
  }
  See examples of application.
}

\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris\cr
  \cr
  Bernard Desgraupes \cr
  \email{bernard.desgraupes@u-paris10.fr}\cr
  University of Paris Ouest - Nanterre
}

\section{English correction}{
  Jean-Marc Chamot \cr
  \email{jchamot@u-paris10.fr}\cr
  Laboratoire "Sport & Culture" / "Sports & Culture" Laboratory \cr
  University of Paris Ouest - Nanterre
}


\references{HTML web site \url{http://www.w3.org/TR/html/}\cr
Data are available on line: \url{http://christophe.genolini.free.fr/EPO/EPO2007-Fraude.php}}



\seealso{
  \code{\link{rthMainFile}},
  \code{\link{rthb}},
  \code{\link{r2lUniv-package}},
  \code{\link{examCheating}}
}

\examples{
 # # # # # # # # # # # # # # # # # # #
#   R to HTML,  Univariate Analyses   #
 #             Examples              #
  #       rthu single variable      #
   # # # # # # # # # # # # # # # # #

########################

### Create some data
par(ask=FALSE)
V1 <- factor(LETTERS[floor(runif(50,1,4))])
V2 <- rnorm(50,1,1)<0
V3 <- ordered(LETTERS[floor(runif(50,1,4))])

### Create a directory for the output
r2lhOutDir <- paste(tempdir(),"rthuExample",sep="/")
if(!file.exists(r2lhOutDir)){dir.create(r2lhOutDir)}
setwd(r2lhOutDir)

### Execute rthu
rthu(V1,fileOut="first.html",textBefore="<h2>Variable 1 to 3</h2>",graphName="V1")
rthu(V2,fileOut="second.html",graphName="V2")
rthu(V3,fileOut="third.html",textBefore="This is variable 3",graphDir="P")
rthMainFile(text="
<LU>
<LI><A HREF='first.html'>First example</A></LI>
<LI><A HREF='second.html'>Second example</A></LI>
<LI><A HREF='third.html'>Third example</A></LI>
</LU>
")


 # # # # # # # # # # # # # # # # # # #
#   R to HTML,  Univariate Analyses   #
 #          Real examples            #
  #        rthu data.frame          #
   # # # # # # # # # # # # # # # # #

########################
###### Step 1: Create the data

data(examCheating)
str(examCheating)

########################
###### Step 2: ordering variable

examCheating$YearOfStudy <- ordered(examCheating$YearOfStudy,levels=c("L1","L2","L3","M1","M2"))
examCheating$Bac <- ordered(examCheating$Bac,levels=c("Remedial exam","Pass","Fairly good","Good","Very good","Summa cum laude"))
for(iColumn in 8:17){
    examCheating[,iColumn] <- ordered(examCheating[,iColumn],levels=c("Never","Rarely","Sometimes","Often","Always"))
}
str(examCheating)


########################
###### Step 3: running r2hu

### The following code will create some files.
### So we first move to a directory.
r2lhOutDir <- paste(tempdir(),"rthuReal",sep="/")
if(!file.exists(r2lhOutDir)){dir.create(r2lhOutDir)}
setwd(r2lhOutDir)


### Then we prepare the textBefore, for transition between variable
textBefore <- paste("<h3>",names(examCheating)[c(2:5,18:20)],"</h3>",sep="")

text <- "
<h2>Survey</h2>
  <ul>
    <li> What is your age?</li>
    <li> What is your gender?<li>
    <li> What is your level?<li>
    <li> What is your field?<li>
    <li> Did you cheat at Bac?<li>
    <li> Did you cheat high scool?<li>
    <li> Cheating score<li>
  </ul>

<h2>Univariate analysis</h2>
  <OBJECT data = 'ExamCheat-univ.html' type = 'text/html'></OBJECT>


<h2>More information?</h2>
For a detailled analysis, see
http://christophe.genolini.free.fr/EPO/2007 Fraude/EPO2007-Fraude-Rapport.pdf"

### We can run r2hu
rthu(examCheating[,c(2:5,18:20)],fileOut="ExamCheat-univ.html",textBefore=textBefore)
rthMainFile("ExamCheat-main.html",text=text)
setwd("../..")
}

\keyword{print}        % Printing
\keyword{classes}      % Data type
\keyword{programming}  % Programming
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{univar}       % Simple univariate statistics




