% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{decorate.party}
\alias{decorate.party}
\title{Decorates a "party" object with a "predicted" element.}
\usage{
\method{decorate}{party}(x, ...)
}
\arguments{
\item{x}{A "party" object.}

\item{...}{Arguments to pass on to the "decorate.default" function.}
}
\description{
Decorates a "party" object with a "predicted" element.
}
\examples{
library("evtree")
library("r2pmml")

data(iris)
iris.party = evtree(Species ~ ., data = iris,
    control = evtree.control(max_depth = 3))
iris.party = decorate(iris.party)
r2pmml(iris.party, file.path(tempdir(), "Iris-Party.pmml"))
}
