/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RVector;

public class RStringVector
extends RVector<String> {
    private List<String> values = null;
    public static final RStringVector EMPTY = new RStringVector(Collections.emptyList(), null);
    private static final Function<String, String> FUNCTION_DEQUOTE = new Function<String, String>(){

        public String apply(String string) {
            if (string.length() > 1 && string.charAt(0) == '`' && string.charAt(string.length() - 1) == '`') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }
    };

    public RStringVector(List<String> values, RPair attributes) {
        super(attributes);
        this.setValues(values);
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String getDequotedValue(int i) {
        return (String)FUNCTION_DEQUOTE.apply((Object)this.getValue(i));
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    public List<String> getDequotedValues() {
        return Lists.transform(this.getValues(), FUNCTION_DEQUOTE);
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    private void setValues(List<String> values) {
        this.values = values;
    }
}

