/*
 * Copyright (c) 2023 Villu Ruusmann
 *
 * This file is part of JPMML-R
 *
 * JPMML-R is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JPMML-R is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with JPMML-R.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.jpmml.rexp;

public class RVectorUtil {

	private RVectorUtil(){
	}

	static
	public void checkSize(RVector<?>... vectors){
		RVector<?> prevVector = null;

		for(RVector<?> vector : vectors){

			if(prevVector != null && vector.size() != prevVector.size()){
				throw new IllegalArgumentException("Expected the same number of elements, got a different number of elements");
			}

			prevVector = vector;
		}
	}
}