% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_figure.R
\name{rtf_figure}
\alias{rtf_figure}
\title{Add Figure Attributes}
\usage{
rtf_figure(tbl, fig_width = 5, fig_height = 5)
}
\arguments{
\item{tbl}{A data frame.}

\item{fig_width}{the width of figures in inch}

\item{fig_height}{the height of figures in inch}
}
\value{
the same data frame \code{tbl} with additional attributes for figure body
}
\description{
Add Figure Attributes
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item If page attributes are NULL then assign default page attributes using `rtf_page()` function.
   \item Check if input width and height are greater than zero.
   \item Define figure width and height attributes based on the inputs.
   \item Return to `tbl` with figure width and height attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
\dontrun{
library(dplyr) # required to run examples
file <- file.path(tempdir(), "figure1.png")
png(file)
plot(1:10)
dev.off()

# Read in PNG file in binary format
rtf_read_png(file) \%>\%
  rtf_figure() \%>\%
  attributes()
}

}
