% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_rtf_border.R
\name{obj_rtf_border}
\alias{obj_rtf_border}
\title{Create an RTF Table Border Object}
\usage{
obj_rtf_border(
  tbl,
  border_left = "single",
  border_right = "single",
  border_top = "",
  border_bottom = "",
  border_first = "single",
  border_last = "single",
  border_color_left = NULL,
  border_color_right = NULL,
  border_color_top = NULL,
  border_color_bottom = NULL,
  border_color_first = NULL,
  border_color_last = NULL,
  border_width = 15,
  cell_height = 0.15,
  cell_justification = "c",
  cell_nrow = NULL
)
}
\arguments{
\item{tbl}{A data frame.}

\item{border_left}{Left border type. To vary left border by column, use
character vector with length of vector equal to number of columns displayed
e.g. c("single","single","single"). All possible input can be found in
\code{r2rtf:::border_type()$name}.}

\item{border_right}{Right border type. To vary right border by column, use
character vector with length of vector equal to number of columns displayed
e.g. c("single","single","single"). All possible input can be found in
\code{r2rtf:::border_type()$name}.}

\item{border_top}{Top border type. To vary top border by column, use
character vector with length of vector equal to number of columns displayed
e.g. c("single","single","single"). If it is the first row in a table for this
page, the top border is set to "double" otherwise the border is set to "single".
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_bottom}{Bottom border type.
To vary bottom border by column, use character vector with length of vector
equal to number of columns displayed e.g. c("single","single","single").
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_first}{First top border type of the whole table. Default is "double" indicating double line bottom border.
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_last}{Last bottom border type of the whole table. Default is "double" indicating double line bottom border.
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_color_left}{Left border color type. Default is NULL for black. To vary left
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_right}{Right border color type. Default is NULL for black. To vary right
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_top}{Top border color type. Default is NULL for black. To vary top
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_bottom}{Bottom border color type. Default is NULL for black. To vary bottom
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_first}{First top border color type of the whole table. Default is NULL for black.
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_last}{Last bottom border color type of the whole table. Default is NULL for black.
All possible input can be found in \code{grDevices::colors()}.}

\item{border_width}{Border width in twips. Default is 15 for 0.0104 inch.}

\item{cell_height}{Cell height in inches. Default is 0.15 for 0.15 inch.}

\item{cell_justification}{Justification type for cell. Default is "c" for center justification.
All possible input can be found in \code{r2rtf:::justification()$type}.}

\item{cell_nrow}{Number of rows required in each cell. Default is NULL.}
}
\value{
the same \code{tbl} with additional border attributes
}
\description{
Create an RTF Table Border Object
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Input checks using \code{check_args()}, \code{match_arg()} and \code{stopifnot()}.
   \item Define border attributes based on the input.
   \item Register use_color attribute.
   \item Return \code{tbl} with attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

