% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_nrow.R
\name{nrow_paragraph}
\alias{nrow_paragraph}
\title{Calculate Number of Rows for a Paragraph}
\usage{
nrow_paragraph(tbl, size, padding = 0.2)
}
\arguments{
\item{tbl}{A data frame's \code{rtf_title}, \code{rtf_subline}, \code{rtf_footnote}, or \code{rtf_source} attribute containing \code{strwidth} attribute}

\item{size}{Size of a line in inches}

\item{padding}{Cell padding in inches}
}
\value{
an integer (number of rows) for title, subline, footnote, or source
}
\description{
Calculate number of rows for a paragraph like title, subline, footnote, source
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{tbl} is a data frame's `rtf_title`, `rtf_subline`, `rtf_footnote`, or `rtf_source` attribute containing `strwidth` attribute.
   \item Return an integer (number of rows) for title, subline, footnote, or source
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr) # required for running example
tb <- head(iris) \%>\%
  rtf_title(title = "Iris example") \%>\%
  rtf_footnote(footnote = c("footnote 1", "footnote 2")) \%>\%
  rtf_body()

r2rtf:::nrow_paragraph(attr(tb, "rtf_title"), 6.25)
r2rtf:::nrow_paragraph(attr(tb, "rtf_footnote"), 6.25)
}
