% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_subset.R
\name{rtf_subset}
\alias{rtf_subset}
\title{Pass Table Attributes to Subset Table}
\usage{
rtf_subset(tbl, row = 1:nrow(tbl), col = 1:ncol(tbl))
}
\arguments{
\item{tbl}{A data frame with attributes.}

\item{row}{a numeric vector for the row index to keep in the subsetted data.}

\item{col}{a numeric vector for the column index to keep in the subsetted data.}
}
\value{
the subsetted data frame \code{tbl_sub} with original attributes from \code{tbl}
}
\description{
Pass original table attributes assigned through like \code{rtf_page}, \code{rtf_title}, \code{rtf_body}... to subsetted table
because original attributes won't be automatically carried over.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{tbl} is a data frame with attributes to be subsetted.
   \item Return a data frame \code{tbl_sub} subsetted from \code{tbl} with original table attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr)
data(r2rtf_tbl1)
sub_table <- r2rtf_tbl1 \%>\%
  rtf_body() \%>\%
  r2rtf:::rtf_subset(row = 1:2, col = c(1, 4:5))

attributes(sub_table)
}
