% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{linesSPSS}
\alias{linesSPSS}
\title{Line Plots}
\usage{
linesSPSS(data, variables, index = NULL, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{a character vector specifying at least one variable to be
plotted on the \eqn{y}-axis.  In case of multiple variables, separate lines
are drawn for each variable and a legend is shown.}

\item{index}{a character string specifying a variable to be plotted on the
\eqn{x}-axis, or \code{NULL} to plot the observations against their index.}

\item{xlab, ylab}{the axis labels.}

\item{\dots}{additional arguments to be passed down, in particular
graphical parameters (see \code{\link[graphics]{par}}).}
}
\value{
Nothing is returned, but a plot is produced.
}
\description{
Draw connected lines for variables in a data frame.  The plot thereby mimics
the look of SPSS graphs.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# aggregate log market values by position
means <- aggregate(Eredivisie[, "logMarketValue", drop = FALSE],
                   Eredivisie[, "Position", drop = FALSE],
                   FUN = mean)

# create profile plot
linesSPSS(means, "logMarketValue", "Position")

# easier and fancier as the plot method of ANOVA results
oneway <- ANOVA(Eredivisie, "logMarketValue",
                group = "Position")
plot(oneway)

}
\author{
Andreas Alfons
}
\keyword{hplot}
