% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{m_animate}
\alias{m_animate}
\title{Animate all models in viewer from their respective frames}
\usage{
m_animate(id, options)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{options}{can specify \code{interval} (speed of animation), \code{loop}
(direction of looping, \code{'backward'}, \code{'forward'} or
\code{'backAndForth'}), step interval between frames (\code{'step'}), and
\code{reps} (number of repetitions, \code{0} indicates infinite loop)}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Animate all models in viewer from their respective frames
}
\examples{
library(r3dmol)

xyz <- "4
* (null), Energy   -1000.0000000
N     0.000005    0.019779   -0.000003   -0.157114    0.000052   -0.012746
H     0.931955   -0.364989    0.000003    1.507100   -0.601158   -0.004108
H    -0.465975   -0.364992    0.807088    0.283368    0.257996   -0.583024
H    -0.465979   -0.364991   -0.807088    0.392764    0.342436    0.764260
"

r3dmol(
  width = 400,
  height = 400,
  backgroundColor = "0xeeeeee"
) \%>\%
  m_add_model(
    data = xyz,
    format = "xyz",
    options = list(vibrate = list(frames = 10, amplitude = 1))
  ) \%>\%
  m_set_style(style = m_style_stick()) \%>\%
  m_animate(list(loop = "backAndForth")) \%>\%
  m_zoom_to()
}
