% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSobjects.R
\name{shape3js}
\alias{shape3js}
\title{Add a generic shape to an 3js plot}
\usage{
shape3js(
  data3js,
  vertices,
  faces,
  normals = NULL,
  col = "black",
  highlight,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{vertices}{An nx3 matrix of 3d vertex coordinates}

\item{faces}{An nx3 matrix of indices relating to vertices that make up each triangular face}

\item{normals}{Optional nx3 matrix of normals to each vertex}

\item{col}{Shape color}

\item{highlight}{highlight attributes (see \code{highlight3js()})}

\item{...}{Additional attributes to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
Add a generic shape to an 3js plot
}
\examples{
# Draw a teapot
data(teapot)
p <- plot3js(
  xlim = range(teapot$vertices[,1]),
  ylim = range(teapot$vertices[,2]),
  zlim = range(teapot$vertices[,3]),
  label_axes = FALSE,
  aspect = c(1, 1, 1)
)

p <- shape3js(
  p,
  vertices = teapot$vertices,
  faces = teapot$edges,
  col = "lightblue"
)

r3js(p, rotation = c(-2.8, 0, 3.14), zoom = 1.2)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
