% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_fitbiasramp.R
\name{SS_fitbiasramp}
\alias{SS_fitbiasramp}
\title{Estimate bias adjustment for recruitment deviates}
\usage{
SS_fitbiasramp(replist, verbose = FALSE, startvalues = NULL,
  method = "BFGS", twoplots = TRUE, transform = FALSE, plot = TRUE,
  print = FALSE, plotdir = "default", shownew = TRUE, oldctl = NULL,
  newctl = NULL, altmethod = "nlminb", pwidth = 6.5, pheight = 5,
  punits = "in", ptsize = 10, res = 300, cex.main = 1)
}
\arguments{
\item{replist}{Object created using \code{\link{SS_output}}}

\item{verbose}{Controls the amount of output to the screen.  Default=FALSE.}

\item{startvalues}{A vector of 5 values for the starting points in the
minimization. Default=NULL.}

\item{method}{A method to apply to the 'optim' function. See ?optim for
options. Default="BFGS". By default, optim is not used, and the optimization
is based on the input \code{altmethod}.}

\item{twoplots}{Make a two-panel plot showing devs as well as transformed
uncertainty, or just the second panel in the set?  Default=TRUE.}

\item{transform}{An experimental option to treat the transform the 5
quantities to improve minimization. Doesn't work well. Default=FALSE.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{plotdir}{Directory where PNG files will be written. By default it will
be the directory where the model was run.}

\item{shownew}{Include new estimated bias adjustment values on top of values
used in the model? (TRUE/FALSE)}

\item{oldctl}{Optional name of existing control file to modify.
Default=NULL.}

\item{newctl}{Optional name of new control file to create from old file with
estimated bias adjustment values. Default=NULL.}

\item{altmethod}{Optimization tool to use in place of optim, either "nlminb"
or "psoptim". If not equal to either of these, then optim is used.}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. Default=7.}

\item{pheight}{Default height width of plots printed to files in units of
\code{punits}. Default=7.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" or "mm". Default="in".}

\item{ptsize}{Point size for plotted text in plots printed to files (see
help("png") in R for details). Default=12.}

\item{res}{Resolution of plots printed to files. Default=300.}

\item{cex.main}{Character expansion for plot titles.}
}
\description{
Uses standard error of estimated recruitment deviates to estimate the 5
controls for the bias adjustment in Stock Synthesis
}
\author{
Ian Taylor
}
\references{
Methot, R.D. and Taylor, I.G., 2011. Adjusting for bias due to
variability of estimated recruitments in fishery assessment models.  Can. J.
Fish. Aquat. Sci., 68:1744-1760.
}
\seealso{
\code{\link{SS_output}}
}
\keyword{data}
\keyword{hplot}
\keyword{manip}

