% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotProfile.R
\name{SSplotProfile}
\alias{SSplotProfile}
\title{Plot likelihood profile results}
\usage{
SSplotProfile(summaryoutput, plot = TRUE, print = FALSE,
  models = "all", profile.string = "steep",
  profile.label = "Spawner-recruit steepness (h)", exact = FALSE,
  ylab = "Change in -log-likelihood", components = c("TOTAL", "Catch",
  "Equil_catch", "Survey", "Discard", "Mean_body_wt", "Length_comp",
  "Age_comp", "Size_at_age", "SizeFreq", "Morphcomp", "Tag_comp",
  "Tag_negbin", "Recruitment", "InitEQ_Regime", "Forecast_Recruitment",
  "Parm_priors", "Parm_softbounds", "Parm_devs", "F_Ballpark",
  "Crash_Pen"), component.labels = c("Total", "Catch",
  "Equilibrium catch", "Index data", "Discard", "Mean body weight",
  "Length data", "Age data", "Size-at-age data", "Generalized size data",
  "Morph composition data", "Tag recapture distribution",
  "Tag recapture total", "Recruitment", "Initital equilibrium recruitment",
  "Forecast recruitment", "Priors", "Soft bounds", "Parameter deviations",
  "F Ballpark", "Crash penalty"), minfraction = 0.01,
  sort.by.max.change = TRUE, col = "default", pch = "default",
  lty = 1, lty.total = 1, lwd = 2, lwd.total = 3, cex = 1,
  cex.total = 1.5, xlim = "default", ymax = "default", xaxs = "r",
  yaxs = "r", type = "o", legend = TRUE, legendloc = "topright",
  pwidth = 6.5, pheight = 5, punits = "in", res = 300,
  ptsize = 10, cex.main = 1, plotdir = NULL, add_cutoff = FALSE,
  cutoff_prob = 0.95, verbose = TRUE, ...)
}
\arguments{
\item{summaryoutput}{List created by the function \code{\link{SSsummarize}}.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{models}{Optional subset of the models described in
\code{summaryoutput}.  Either "all" or a vector of numbers indicating
columns in summary tables.}

\item{profile.string}{Character string used to find parameter over which the
profile was conducted. If \code{exact=FALSE}, this can be a substring of
one of the SS parameter labels found in the Report.sso file.
For instance, the default input 'steep'
matches the parameter 'SR_BH_steep'. If \code{exact=TRUE}, then
profile.string needs to be an exact match to the parameter label.}

\item{profile.label}{Label for x-axis describing the parameter over which
the profile was conducted.}

\item{exact}{Should the \code{profile.string} have to match the parameter
label exactly, or is a substring OK.}

\item{ylab}{Label for y-axis. Default is "Change in -log-likelihood".}

\item{components}{Vector of likelihood components that may be included in
plot. List is further refined by any components that are not present in
model or have little change over range of profile (based on limit
\code{minfraction}). Hopefully this doesn't need to be changed.}

\item{component.labels}{Vector of labels for use in the legend that matches
the vector in \code{components}.}

\item{minfraction}{Minimum change in likelihood (over range considered) as a
fraction of change in total likelihood for a component to be included in the
figure.}

\item{sort.by.max.change}{Switch giving option to sort components in legend
in order of maximum amount of change in likelihood (over range considered).
Default=TRUE.}

\item{col}{Optional vector of colors for each line.}

\item{pch}{Optional vector of plot characters for the points.}

\item{lty}{Line total for the likelihood components.}

\item{lty.total}{Line type for the total likelihood.}

\item{lwd}{Line width for the likelihood components.}

\item{lwd.total}{Line width for the total likelihood.}

\item{cex}{Character expansion for the points representing the likelihood
components.}

\item{cex.total}{Character expansion for the points representing the total
likelihood.}

\item{xlim}{Range for x-axis. Change in likelihood is calculated relative to
values within this range.}

\item{ymax}{Maximum y-value. Default is 10\% greater than largest value
plotted.}

\item{xaxs}{The style of axis interval calculation to be used for the x-axis
(see ?par for more info)}

\item{yaxs}{The style of axis interval calculation to be used for the y-axis
(see ?par for more info).}

\item{type}{Line type (see ?plot for more info).}

\item{legend}{Include legend?}

\item{legendloc}{Location of legend (see ?legend for more info).}

\item{pwidth}{Width of plot}

\item{pheight}{Height of plot}

\item{punits}{Units for PNG file}

\item{res}{Resolution for PNG file}

\item{ptsize}{Point size for PNG file}

\item{cex.main}{Character expansion for plot titles}

\item{plotdir}{Directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{add_cutoff}{Add dashed line at ~1.92 to indicate 95% confidence interval
based on common cutoff of half of chi-squared of p=.95 with 1 degree of
freedom: \code{0.5*qchisq(p=cutoff_prob, df=1)}. The probability value
can be adjusted using the \code{cutoff_prob} below.}

\item{cutoff_prob}{Probability associated with \code{add_cutoff} above.}

\item{verbose}{Return updates of function progress to the R GUI? (Doesn't do
anything yet.)}

\item{\dots}{Additional arguments passed to the \code{plot} command.}
}
\description{
Makes a plot of change in negative-log-likelihood for each likelihood
component that contributes more than some minimum fraction of change in
total.
}
\note{
Someday the function \code{\link{SS_profile}} will be improved and
made to work directly with this plotting function, but they don't yet work
well together. Thus, even if \code{\link{SS_profile}} is used, the output
should be read using \code{\link{SSgetoutput}} or by multiple calls to
\code{\link{SS_output}}.
}
\seealso{
\code{\link{SSsummarize}}, \code{\link{SS_profile}},
\code{\link{SS_output}}, \code{\link{SSgetoutput}}
}
\author{
Ian Taylor, Ian Stewart
}
