% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_multifig_sexratio.R
\name{make_multifig_sexratio}
\alias{make_multifig_sexratio}
\title{Create multi-figure sex ratio plots.}
\usage{
make_multifig_sexratio(dbase, sexratio.option = 2, CI = 0.75,
  sampsizeround = 1, maxrows = 6, maxcols = 6, rows = 1,
  cols = 1, fixdims = TRUE, main = "", cex.main = 1, xlab = "",
  ylab = "Fraction female", horiz_lab = "default", xbuffer = c(0.1,
  0.1), ybuffer = "default", yupper = NULL, axis1 = NULL,
  axis2 = NULL, ptscex = 1, ptscol = gray(0.5), linescol = 4,
  lty = 1, lwd = 2, nlegends = 3, legtext = list("yr", "sampsize",
  "effN"), legx = "default", legy = "default", legadjx = "default",
  legadjy = "default", legsize = c(1.2, 1), legfont = c(2, 1),
  ipage = 0, multifig_oma = c(5, 5, 5, 2) + 0.1, ...)
}
\arguments{
\item{dbase}{element of list created by \code{\link{SS_output}} passed from
\code{\link{SSplotSexRatio}}}

\item{sexratio.option}{code to choose among (1) female:male ratio or
(2) fraction females out of the total (the default)}

\item{CI}{confidence interval for uncertainty}

\item{sampsizeround}{rounding level for sample size values}

\item{maxrows}{maximum (or fixed) number or rows of panels in the plot}

\item{maxcols}{maximum (or fixed) number or columns of panels in the plot}

\item{rows}{number or rows to return to as default for next plots to come or
for single plots}

\item{cols}{number or cols to return to as default for next plots to come or
for single plots}

\item{fixdims}{fix the dimensions at maxrows by maxcols or resize based on
number of elements in \code{yr} input.}

\item{main}{title of plot}

\item{cex.main}{character expansion for title}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{horiz_lab}{axis labels set horizontal all the time (TRUE), never
(FALSE) or only when relatively short ("default")}

\item{xbuffer}{extra space around points on the left and right as fraction
of total width of plot}

\item{ybuffer}{extra space around points on the bottom and top as fraction
of total height of plot. "default" will cause c(0,.15) for sexratio.option=1
and c(.15, .3) for sexratio.option=2.}

\item{yupper}{upper limit on ymax (applied before addition of ybuffer)}

\item{axis1}{position of bottom axis values}

\item{axis2}{position of left size axis values}

\item{ptscex}{character expansion factor for points (default=1)}

\item{ptscol}{color for points/bars}

\item{linescol}{color for fitted model}

\item{lty}{line type}

\item{lwd}{line width}

\item{nlegends}{number of lines of text to add as legends in each plot}

\item{legtext}{text in legend, a list of length=nlegends. values may be any
of 1.  "yr", 2. "sampsize", 3. "effN", or a vector of length = ptsx.}

\item{legx}{vector of length=nlegends of x-values of legends (default is
first one on left, all after on right)}

\item{legy}{vector of length=nlegends of y-values of legends (default is top
for all plots)}

\item{legadjx}{left/right adjustment of legends around legx}

\item{legadjy}{left/right adjustment of legends around legy}

\item{legsize}{font size for legends. default=c(1.2,1.0) (larger for year
and normal for others)}

\item{legfont}{font type for legends, same as "font" under ?par}

\item{ipage}{which page of plots when covering more than will fit within
maxrows by maxcols.}

\item{multifig_oma}{vector of outer margins. Can be input to SS_plots and will be
passed to this function via the ... argument.}

\item{\dots}{additional arguments (NOT YET IMPLEMENTED).}
}
\description{
Modified version of \code{\link{make_multifig}} for multi-figure
plots of sex ratio data with crude confidence intervals (+/i 1 se) and
fits from Stock Synthesis output.
}
\details{
The SE of the sex ratio is crude and calculated as
follows. First, assume a multinomial which as MLEs of proportions. Then
use the delta method of the ratio F/M, using the MLE as the expected
values and analytical variances and covariance between F and M. After
some algebra this calculation reduces to: SE(F/M)= sqrt((f/m)^2*(
(1-f)/(f*N) + (1-m)/(m*N) +2/N )). Confidence intervals created from
these should be considered very crude and would not necessarily be
appropriate for future alternative compositional likelihoods.

This function was derived from make_multifig and hence has a lot of
overlap in functionality and arguments.
}
\seealso{
\code{\link{SS_plots}},\code{\link{SSplotSexRatio}}
}
\author{
Cole Monnahan. Adapted from \code{\link{make_multifig}}.
}
