/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.FreeFormPointSet;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.decay.DecayFunction;
import com.conveyal.r5.analyst.decay.ExponentialDecayFunction;
import com.conveyal.r5.analyst.decay.FixedExponentialDecayFunction;
import com.conveyal.r5.analyst.decay.LinearDecayFunction;
import com.conveyal.r5.analyst.decay.LogisticDecayFunction;
import com.conveyal.r5.analyst.decay.StepDecayFunction;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.transit.TransportNetwork;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.R5MultiDestinationProcess;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessibilityEstimator
extends R5MultiDestinationProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AccessibilityEstimator.class);
    private FreeFormPointSet destinationPoints = null;
    private DecayFunction decayFunction;

    public void setDecayFunction(String decayFunction, double decayValue) {
        if ((decayFunction = decayFunction.toUpperCase()).equals("STEP")) {
            this.decayFunction = new StepDecayFunction();
        }
        if (decayFunction.equals("EXPONENTIAL")) {
            this.decayFunction = new ExponentialDecayFunction();
        }
        if (decayFunction.equals("FIXED_EXPONENTIAL")) {
            this.decayFunction = new FixedExponentialDecayFunction();
            ((FixedExponentialDecayFunction)this.decayFunction).decayConstant = decayValue;
        }
        if (decayFunction.equals("LINEAR")) {
            this.decayFunction = new LinearDecayFunction();
            ((LinearDecayFunction)this.decayFunction).widthMinutes = (int)decayValue;
        }
        if (decayFunction.equals("LOGISTIC")) {
            this.decayFunction = new LogisticDecayFunction();
            ((LogisticDecayFunction)this.decayFunction).standardDeviationMinutes = decayValue;
        }
        this.decayFunction.prepare();
    }

    public AccessibilityEstimator(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    public List<LinkedHashMap<String, ArrayList<Object>>> run() throws ExecutionException, InterruptedException {
        this.buildDestinationPointSet();
        return super.run();
    }

    private void buildDestinationPointSet() {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        DataOutputStream pointStream = new DataOutputStream(dataStream);
        try {
            pointStream.writeInt(this.toIds.length);
            for (String toId : this.toIds) {
                pointStream.writeUTF(toId);
            }
            for (double toLat : this.toLats) {
                pointStream.writeDouble(toLat);
            }
            for (double toLon : this.toLons) {
                pointStream.writeDouble(toLon);
            }
            for (int opportunity : this.opportunities) {
                pointStream.writeDouble(opportunity);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataStream.toByteArray());
        try {
            this.destinationPoints = new FreeFormPointSet((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.directModes.isEmpty()) {
            for (LegMode mode : this.directModes) {
                this.transportNetwork.linkageCache.getLinkage((PointSet)this.destinationPoints, this.transportNetwork.streetLayer, StreetMode.valueOf((String)mode.toString()));
            }
        }
    }

    @Override
    protected LinkedHashMap<String, ArrayList<Object>> runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        TravelTimeComputer computer = new TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        RDataFrame travelTimesTable = this.buildDataFrameStructure(this.fromIds[index]);
        this.populateDataFrame(travelTimeResults, travelTimesTable);
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable.getDataFrame();
        }
        return null;
    }

    private void populateDataFrame(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        int[][][] accessibility = travelTimeResults.accessibility.getIntValues();
        int nPercentiles = this.routingProperties.percentiles.length;
        int nCutoffs = this.routingProperties.cutoffs.length;
        for (int p = 0; p < nPercentiles; ++p) {
            for (int c = 0; c < nCutoffs; ++c) {
                travelTimesTable.append();
                travelTimesTable.set("percentile", this.routingProperties.percentiles[p]);
                travelTimesTable.set("cutoff", this.routingProperties.cutoffs[c]);
                travelTimesTable.set("accessibility", accessibility[0][p][c]);
            }
        }
    }

    private RDataFrame buildDataFrameStructure(String fromId) {
        RDataFrame travelTimesTable = new RDataFrame();
        travelTimesTable.addStringColumn("from_id", fromId);
        travelTimesTable.addIntegerColumn("percentile", 0);
        travelTimesTable.addIntegerColumn("cutoff", 0);
        travelTimesTable.addIntegerColumn("accessibility", 0);
        return travelTimesTable;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.destinationPointSetKeys = new String[1];
        request.destinationPointSetKeys[0] = "opportunities";
        request.destinationPointSets = new PointSet[1];
        request.destinationPointSets[0] = this.destinationPoints;
        request.percentiles = this.routingProperties.percentiles;
        request.recordAccessibility = true;
        request.recordTimes = false;
        request.includePathResults = false;
        request.decayFunction = this.decayFunction;
        request.cutoffsMinutes = this.routingProperties.cutoffs;
        return request;
    }
}

