/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.decay.DecayFunction;
import com.conveyal.r5.analyst.decay.ExponentialDecayFunction;
import com.conveyal.r5.analyst.decay.FixedExponentialDecayFunction;
import com.conveyal.r5.analyst.decay.LinearDecayFunction;
import com.conveyal.r5.analyst.decay.LogisticDecayFunction;
import com.conveyal.r5.analyst.decay.StepDecayFunction;
import com.conveyal.r5.transit.TransportNetwork;
import java.text.ParseException;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.R5MultiDestinationProcess;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;

public class AccessibilityEstimator
extends R5MultiDestinationProcess {
    private DecayFunction decayFunction;

    public void setDecayFunction(String decayFunction, double decayValue) {
        if ((decayFunction = decayFunction.toUpperCase()).equals("STEP")) {
            this.decayFunction = new StepDecayFunction();
        }
        if (decayFunction.equals("EXPONENTIAL")) {
            this.decayFunction = new ExponentialDecayFunction();
        }
        if (decayFunction.equals("FIXED_EXPONENTIAL")) {
            this.decayFunction = new FixedExponentialDecayFunction();
            ((FixedExponentialDecayFunction)this.decayFunction).decayConstant = decayValue;
        }
        if (decayFunction.equals("LINEAR")) {
            this.decayFunction = new LinearDecayFunction();
            ((LinearDecayFunction)this.decayFunction).widthMinutes = (int)decayValue;
        }
        if (decayFunction.equals("LOGISTIC")) {
            this.decayFunction = new LogisticDecayFunction();
            ((LogisticDecayFunction)this.decayFunction).standardDeviationMinutes = decayValue;
        }
        this.decayFunction.prepare();
    }

    public AccessibilityEstimator(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    protected RDataFrame runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        TravelTimeComputer computer = new TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        RDataFrame travelTimesTable = this.buildDataFrameStructure(this.fromIds[index], 10);
        this.populateDataFrame(travelTimeResults, travelTimesTable);
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable;
        }
        return null;
    }

    private void populateDataFrame(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        int[][][] accessibility = travelTimeResults.accessibility.getIntValues();
        int nPercentiles = this.routingProperties.percentiles.length;
        int nCutoffs = this.routingProperties.cutoffs.length;
        for (int p = 0; p < nPercentiles; ++p) {
            for (int c = 0; c < nCutoffs; ++c) {
                travelTimesTable.append();
                travelTimesTable.set("percentile", this.routingProperties.percentiles[p]);
                travelTimesTable.set("cutoff", this.routingProperties.cutoffs[c]);
                travelTimesTable.set("accessibility", accessibility[0][p][c]);
            }
        }
    }

    @Override
    protected RDataFrame buildDataFrameStructure(String fromId, int nRows) {
        RDataFrame travelTimesTable = new RDataFrame(nRows);
        travelTimesTable.addStringColumn("from_id", fromId);
        travelTimesTable.addIntegerColumn("percentile", 0);
        travelTimesTable.addIntegerColumn("cutoff", 0);
        travelTimesTable.addIntegerColumn("accessibility", 0);
        return travelTimesTable;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.destinationPointSetKeys = new String[1];
        request.destinationPointSetKeys[0] = "opportunities";
        request.destinationPointSets = new PointSet[1];
        request.destinationPointSets[0] = this.destinationPoints;
        request.percentiles = this.routingProperties.percentiles;
        request.recordAccessibility = true;
        request.recordTimes = false;
        request.includePathResults = false;
        request.decayFunction = this.decayFunction;
        request.cutoffsMinutes = this.routingProperties.cutoffs;
        return request;
    }
}

