/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.batch.JobExecutionEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Component
public class JobLauncherCommandLineRunner
implements CommandLineRunner,
ApplicationEventPublisherAware {
    private static Log logger = LogFactory.getLog(JobLauncherCommandLineRunner.class);
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private JobLauncher jobLauncher;
    private JobRegistry jobRegistry;
    private JobExplorer jobExplorer;
    private String jobNames;
    private Collection<Job> jobs = Collections.emptySet();
    private ApplicationEventPublisher publisher;

    public JobLauncherCommandLineRunner(JobLauncher jobLauncher, JobExplorer jobExplorer) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
    }

    public void setJobNames(String jobNames) {
        this.jobNames = jobNames;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Autowired(required=false)
    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    @Autowired(required=false)
    public void setJobParametersConverter(JobParametersConverter converter) {
        this.converter = converter;
    }

    @Autowired(required=false)
    public void setJobs(Collection<Job> jobs) {
        this.jobs = jobs;
    }

    public void run(String ... args) throws JobExecutionException {
        logger.info((Object)("Running default command line with: " + Arrays.asList(args)));
        this.launchJobFromProperties(StringUtils.splitArrayElementsIntoProperties((String[])args, (String)"="));
    }

    protected void launchJobFromProperties(Properties properties) throws JobExecutionException {
        JobParameters jobParameters = this.converter.getJobParameters(properties);
        this.executeLocalJobs(jobParameters);
        this.executeRegisteredJobs(jobParameters);
    }

    private JobParameters getNextJobParameters(Job job, JobParameters additionalParameters) {
        String name = job.getName();
        JobParameters parameters = new JobParameters();
        List lastInstances = this.jobExplorer.getJobInstances(name, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        Map additionals = additionalParameters.getParameters();
        if (lastInstances.isEmpty()) {
            if (incrementer != null) {
                parameters = incrementer.getNext(new JobParameters());
            }
        } else {
            List previousExecutions = this.jobExplorer.getJobExecutions((JobInstance)lastInstances.get(0));
            JobExecution previousExecution = (JobExecution)previousExecutions.get(0);
            if (previousExecution == null) {
                if (incrementer != null) {
                    parameters = incrementer.getNext(new JobParameters());
                }
            } else if (this.isStoppedOrFailed(previousExecution)) {
                parameters = previousExecution.getJobParameters();
                this.removeNonIdentifying(additionals);
            } else if (incrementer != null) {
                parameters = incrementer.getNext(previousExecution.getJobParameters());
            }
        }
        return this.merge(parameters, additionals);
    }

    private boolean isStoppedOrFailed(JobExecution execution) {
        BatchStatus status = execution.getStatus();
        return status == BatchStatus.STOPPED || status == BatchStatus.FAILED;
    }

    private void removeNonIdentifying(Map<String, JobParameter> parameters) {
        HashMap<String, JobParameter> copy = new HashMap<String, JobParameter>(parameters);
        for (Map.Entry<String, JobParameter> parameter : copy.entrySet()) {
            if (parameter.getValue().isIdentifying()) continue;
            parameters.remove(parameter.getKey());
        }
    }

    private JobParameters merge(JobParameters parameters, Map<String, JobParameter> additionals) {
        HashMap<String, JobParameter> merged = new HashMap<String, JobParameter>();
        merged.putAll(parameters.getParameters());
        merged.putAll(additionals);
        parameters = new JobParameters(merged);
        return parameters;
    }

    private void executeRegisteredJobs(JobParameters jobParameters) throws JobExecutionException {
        if (this.jobRegistry != null && StringUtils.hasText((String)this.jobNames)) {
            String[] jobsToRun;
            for (String jobName : jobsToRun = this.jobNames.split(",")) {
                try {
                    Job job = this.jobRegistry.getJob(jobName);
                    if (this.jobs.contains(job)) continue;
                    this.execute(job, jobParameters);
                }
                catch (NoSuchJobException nsje) {
                    logger.debug((Object)("No job found in registry for job name: " + jobName));
                }
            }
        }
    }

    protected void execute(Job job, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException, JobParametersNotFoundException {
        JobParameters nextParameters = this.getNextJobParameters(job, jobParameters);
        if (nextParameters != null) {
            JobExecution execution = this.jobLauncher.run(job, nextParameters);
            if (this.publisher != null) {
                this.publisher.publishEvent((ApplicationEvent)new JobExecutionEvent(execution));
            }
        }
    }

    private void executeLocalJobs(JobParameters jobParameters) throws JobExecutionException {
        for (Job job : this.jobs) {
            String[] jobsToRun;
            if (StringUtils.hasText((String)this.jobNames) && !PatternMatchUtils.simpleMatch((String[])(jobsToRun = this.jobNames.split(",")), (String)job.getName())) {
                logger.debug((Object)("Skipped job: " + job.getName()));
                continue;
            }
            this.execute(job, jobParameters);
        }
    }
}

