% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cprd_medcodes.R
\name{patients_per_medcode}
\alias{patients_per_medcode}
\title{Produce a dataset of CPRD medcodes with frequencies of patients in the clinical table}
\usage{
patients_per_medcode(db, clinical_table = "Clinical", patid = "patid",
  medcode = "medcode")
}
\arguments{
\item{db}{a database connection}

\item{clinical_table}{name of the clinical table in the database}

\item{patid}{name of the patid field}

\item{medcode}{name of the medcode field}
}
\description{
This function aggregates all distinct patients matching each CPRD medcode in the clinical table
}
\details{
Note that this does not translate to Read/OXMIS codes.
This function should be fast because all of the heavy lifting happens in SQLite before the data is exported to R
}
\examples{
\dontrun{
medcode_counts <- patients_per_medcode(db)
head(medcode_counts)
} 
}

