% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.plot.network.R
\name{ena.plot.network}
\alias{ena.plot.network}
\title{Plot an ENA network}
\usage{
ena.plot.network(enaplot = NULL, network = NULL,
  node.positions = enaplot$enaset$node.positions,
  adjacency.key = namesToAdjacencyKey(rownames(node.positions)),
  colors = c(pos = "red", "blue"), show.all.nodes = T, threshold = 0,
  thin.lines.in.front = T, opacity = c(0.3, 1), saturation = c(0.25, 1),
  thickness = c(0.1, 1), node.size = c(3, 10), range = c(min(network),
  max(network)), labels = rownames(node.positions), label.offset = NULL,
  label.font.size = enaplot$get("font.size"),
  label.font.color = enaplot$get("font.color"),
  label.font.family = enaplot$get("font.family"), legend.name = NULL,
  legend.include.edges = F, scale.weights = T, ...)
}
\arguments{
\item{enaplot}{\code{\link{ENAplot}} object to use for plotting}

\item{network}{dataframe or matrix containing the edge weights for the network graph; typically comes from ENAset$line.weights}

\item{node.positions}{matrix containing the positiions of the nodes. Defaults to enaplot$enaset$node.positions}

\item{adjacency.key}{matrix containing the adjacency key for looking up the names and positions}

\item{colors}{A String or vector of colors for positive and negative line weights. E.g. red or c(pos= red, neg = blue), default: c(pos= red, neg = blue)}

\item{show.all.nodes}{A Logical variable, default: true}

\item{threshold}{A vector of numeric min/max values, default: (0,1). Edge weights below the min value will not be displayed; edge weights above the max value will be shown at the max value.}

\item{thin.lines.in.front}{A logical, default: true}

\item{opacity}{A vector of numeric min/max values for opacity, default: (0.3,1)}

\item{saturation}{A vector of numeric min/max values for saturation, default: (0.25, 1)}

\item{thickness}{A vector of numeric min/max values for thickness, default: (0, 1)}

\item{node.size}{A lower and upper bound used for scaling the size of the nodes, default c(0, 20)}

\item{range}{A vector of min/max values. Options are numeric, set.min,  set.max, plot.min, plot.max, default: (set.min, set.max). Determines the line weight that corresponds to the thinnest (min) and thickest (max) lines in the network graph}

\item{labels}{A character vector of node labels, default: code names}

\item{label.offset}{A numeric vector of an x and y value to offset labels from the coordinates of the points}

\item{label.font.size}{An integer which determines the font size for graph labels, default: enaplot$font.size}

\item{label.font.color}{A character which determines the color of label font, default: enaplot$font.color}

\item{label.font.family}{A character which determines font type, choices: Arial, Courier New, Times New Roman, default: enaplot$font.family}

\item{legend.name}{A character name to include in the legend. Not included in legend when NULL. Default: NULL}

\item{legend.include.edges}{Logical value indicating if the edges should be included in the plot}

\item{scale.weights}{Logical indicating to scale the supplied network}

\item{...}{Additional parameters}
}
\value{
The \code{\link{ENAplot}} provided to the function, with its plot updated to include the nodes and provided connecting lines.
}
\description{
Plot an ENA network: nodes and edges
}
\details{
lots a network graph, including nodes (taken from codes in the ENAplot) and the edges (provided in network)
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum,
  rotation.by = ena.rotate.by.mean,
  rotation.params = list(
      accum$metadata$Condition=="FirstGame",
      accum$metadata$Condition=="SecondGame"
  )
)

plot = ena.plot(set)

unitNames = set$enadata$units

### Subset rotated points and plot Condition 1 Group Mean
first.game = unitNames$Condition == "FirstGame"
first.game.points = set$points.rotated[first.game,]
plot = ena.plot.group(plot, first.game.points, labels = "FirstGame",
    colors = "red", confidence.interval = "box")

### Subset rotated points and plot Condition 2 Group Mean
second.game = unitNames$Condition == "SecondGame"
second.game.points = set$points.rotated[second.game,]
plot = ena.plot.group(plot, second.game.points, labels = "SecondGame",
    colors  = "blue", confidence.interval = "box")

### get mean network plots
first.game.lineweights = set$line.weights[first.game,]
first.game.mean = colMeans(first.game.lineweights)

second.game.lineweights = set$line.weights[second.game,]
second.game.mean = colMeans(second.game.lineweights)

subtracted.network = first.game.mean - second.game.mean
plot = ena.plot.network(plot, network = subtracted.network)
print(plot)

}
\seealso{
\code{\link{ena.plot}}, \code{\link{ena.plot.points}}
}
\keyword{ENA,}
\keyword{edges}
\keyword{network,}
\keyword{nodes,}
\keyword{plot,}

