% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_16_plot_linERR_wf.r
\name{f_plot_linERR_wf}
\alias{f_plot_linERR_wf}
\title{plot likelihood function from wf}
\usage{
f_plot_linERR_wf(object, formula, data, id_name, doses, times, covars, lag,
  exclusion_done = F)
}
\arguments{
\item{object}{an rERR class object}

\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
lin(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{data set returned from f_to_model_data}

\item{id_name}{name of variable containing the names of subjects}

\item{doses}{sub data set of grouped doses}

\item{times}{sub data set of times relatives to doses}

\item{covars}{sub data set of the covars that will be involved in the model (adjustments and stratification)}

\item{lag}{latency period}

\item{exclusion_done}{a logical indicating wheather the exclusion is already done or not}
}
\value{
rERR object with the estimation
}
\description{
plot the partial log likelihood function in the case of one dimension in the linear part
}
\examples{
# set the formulas for the models
formula1  <- Surv(AgeAtEntry,age_at_event,outcome) ~ lin(dose_cum) + strata(sex)

# fit the model
fit1 <- f_fit_linERR_wf(formula1,data=cohort_wf,id_name="id",doses=cohort_wf[,45:79],
                        times=cohort_wf[,10:44],covars=cohort_wf[,c("sex","country")],
                        lag=2,exclusion_done = FALSE)
                        
# plot the partial loglikelihood function
f_plot_linERR_wf(fit1,formula1,data=cohort_wf,id_name="id",doses=cohort_wf[,45:79],
                 times=cohort_wf[,10:44],covars=cohort_wf[,c("sex","country")],
                 lag=2,exclusion_done = FALSE)
}
