% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_00_to_event_table_ef_all.r
\name{f_to_event_table_ef_all}
\alias{f_to_event_table_ef_all}
\title{Data transformation: Event format -> Event format required for the model}
\usage{
f_to_event_table_ef_all(formula, data, id_name, dose_name, time_name,
  covars_names)
}
\arguments{
\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{input data set - event format data set}

\item{id_name}{name of variable containing the names of subjects}

\item{dose_name}{name of the dose variable}

\item{time_name}{name of the time variable}

\item{covars_names}{names of the covars required later in the model}
}
\value{
The data set with the event-row format, including the event of exit of the cohort as a row where the outcome is set
}
\description{
This function organize an input data set ef (event format), to the required ef data set for the model.
It appends an index of person event 1,2..n,0 if a subject has n doses and being the 0-row the exit conditions: exit time, exit dose and the outcome.
Also creates the cumulated dose.
}
\examples{
\donttest{ f_to_event_table_ef_all(formula,data,id_name='patientids',
                                            dose_name='dose',time_name='time',
                                            covars=c('sex','country','birthcohort'))}
}
