% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLevel1BWF.R
\name{getLevel1BWF}
\alias{getLevel1BWF}
\title{Get GEDI Pulse Full Waveform (GEDI Level1B)}
\usage{
getLevel1BWF(level1b, shot_number)
}
\arguments{
\item{level1b}{A GEDI Level1B object (output of \code{\link[rGEDI:readLevel1B]{readLevel1B}} function). A S4 object of class "gedi.level1b".}

\item{shot_number}{Shot number. A scalar representing the shot number of a giving pulse.}
}
\value{
Returns an S4 object of class "gedi.fullwaveform".
}
\description{
This function extracts the full waveform of a given pulse from GEDI Level1B data.
}
\details{
Shot numbers can be extracted using \code{\link[rGEDI:readLevel1B]{readLevel1B}} function.
}
\examples{
# Specifying the path to GEDI level1B data (zip file)
level1B_fp_zip <- system.file("extdata",
                  "GEDI01_B_2019108080338_O01964_T05337_02_003_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level1B data
level1Bpath <- unzip(level1B_fp_zip,exdir = dirname(level1B_fp_zip))

# Reading GEDI level1B data (h5 file)
level1b<-readLevel1B(level1Bpath=level1Bpath)

# Extracting GEDI full waveform for a giving shotnumber
wf <- getLevel1BWF(level1b, shot_number="19640521100108408")

# Plotting GEDI Full waveform
oldpar<-par()
par(mfrow = c(1,2), cex.axis = 1.5)
plot(wf, relative=FALSE, polygon=TRUE, type="l", lwd=2, col="forestgreen",
xlab="Waveform Amplitude", ylab="Elevation (m)")

plot(wf, relative=TRUE, polygon=TRUE, type="l", lwd=2, col="forestgreen",
xlab="Waveform Amplitude (\%)", ylab="Elevation (m)")

par(oldpar)
close(level1b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi01_bv001/
}
