% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel2BVPM.R
\name{clipLevel2BVPM}
\alias{clipLevel2BVPM}
\title{Clip GEDI Canopy Cover and Vertical Profile Metrics by Coordinates}
\usage{
clipLevel2BVPM(level2BVPM, xmin, xmax, ymin, ymax)
}
\arguments{
\item{level2BVPM}{A GEDI Level2B object (output of \code{\link[rGEDI:readLevel1B]{readLevel1B}} function).
An S4 object of class "data.table".}

\item{xmin}{Numeric. West longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{xmax}{Numeric. East longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymin}{Numeric. South latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymax}{Numeric. North latitude (y) coordinate of the bounding rectangle, in decimal degrees.}
}
\value{
Returns an S4 object of class \code{\link[data.table:data.table]{data.table-class}}
containing the Canopy Cover and Vertical Profile metrics.
}
\description{
This function clips GEDI level2B derived
Canopy Cover and Vertical Profile metrics a within given bounding coordinates
}
\examples{
# Specifying the path to GEDI level2B data (zip file)
level2B_fp_zip <- system.file("extdata",
                  "GEDI02_B_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Bpath <- unzip(level2B_fp_zip,exdir = dirname(level2B_fp_zip))

# Reading GEDI level2B data (h5 file)
level2b<-readLevel2B(level2Bpath=level2Bpath)

# Extracting canopy cover and vertical profile metrics
level2BVPM<-getLevel2BVPM(level2b)

# Bounding rectangle coordinates
xmin = -44.15036
xmax = -44.10066
ymin = -13.75831
ymax = -13.71244

# Clipping level2BVPM by extent boundary box
level2b_clip <- clipLevel2BVPM(level2BVPM,xmin, xmax, ymin, ymax)

\donttest{
library(leaflet)
leaflet() \%>\%
 addCircleMarkers(level2b_clip$longitude_bin0,
                  level2b_clip$latitude_bin0,
                  radius = 1,
                  opacity = 1,
                  color = "red")  \%>\%
 addScaleBar(options = list(imperial = FALSE)) \%>\%
 addProviderTiles(providers$Esri.WorldImagery)
}

close(level2b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_bv001/
}
