% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Filtering of minicircle sequences}
\usage{
preprocess(files, groups, circ = TRUE, min = 500, max = 1500, writeDNA = TRUE)
}
\arguments{
\item{files}{a character vector containing the fasta file names in the format sampleA.minicircles.fasta, sampleB.minicircles.fasta,... (output of KOMICS).}

\item{groups}{a factor specifying to which group (e.g. species) the samples belong to. It should have the same length as the list of files.}

\item{circ}{a logical parameter. By default non-circularized minicicle sequences will be excluded. If interested in non-circularized sequences as well, set the parameter to FALSE.}

\item{min}{a minimum value for the minicircle sequences length. Default value is set to 500.}

\item{max}{a maximum value for the minicircle sequences length. Default value is set to 1500.}

\item{writeDNA}{a logical parameter. By default filtered minicircle sequences will by written in fasta format to the current working directory. Set to FALSE if only interested in other output values like plots and summary.}
}
\value{
\item{samples}{the sample names (based on the input files).}
\item{N_MC}{a table containing the sample name, which group it belongs to and the number of minicirce sequences (N_MC) before and after filtering.}
\item{plot}{a barplot visualizing the number of minicircle sequences per sample before and after filtering.}
\item{summary}{the total number of minicircle sequences before and after filtering.}
}
\description{
Assembling minicircle sequences with KOMICS generates individual fasta files (one per sample).
The preprocess function allows you to filter the minicircle sequences based on sequence length (as the size of minicircular kDNA is species-specific and variable) and circularization success.
The function will write filtered individual fasta files in the current working directory.
}
\examples{
require(ggplot2)
data(exData)

### setwd("")

### run function
table(exData$species)
pre <- preprocess(files = system.file("extdata", exData$fastafiles, package="rKOMICS"),
                  groups = exData$species,
                  circ = TRUE, min = 500, max = 1200, writeDNA = FALSE)

pre$summary 

### visualize results
barplot(pre$N_MC[,"beforefiltering"], 
        names.arg = pre$N_MC[,1], las=2, cex.names=0.4)

### alter plot
pre$plot + labs(caption = paste0('N of MC sequences before and after filtering, ', Sys.Date()))

}
