% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.uc.R
\name{read.uc}
\alias{read.uc}
\title{Read in uc files}
\usage{
read.uc(file)
}
\arguments{
\item{file}{the name of the UC file that contains the clustering analysis results. The file should be specified with its full name, including the extension (e.g., all.minicircles.circ.id70.uc).}
}
\value{
\item{hits}{a table containing all the hit records from the UC file. Each row of the table represents a hit record, providing information about the alignment between a query sequence and a target sequence.}
\item{clusters}{a table containing all the cluster records from the UC file. Each row of the table represents a cluster record, providing information about the clustering of sequences into clusters.}
\item{clustnumbers}{a vector containing the cluster numbers (0-based). Each element of the vector represents a cluster identified in the clustering analysis.}
}
\description{
The read.uc function is used to read the output of clustering analyses from a UC file. The function stores the information in two tables: one for hit records (H) and one for cluster records (C).
}
