% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtr.lineseries.R
\name{wtr.lineseries}
\alias{wtr.lineseries}
\title{Creates a line based plot of temperature profile time series}
\usage{
wtr.lineseries(wtr, ylab = "Temperature C", ...)
}
\arguments{
\item{wtr}{Data frame of water temperature loaded with
\code{\link{load.ts}}.}

\item{ylab}{y axis title}

\item{\dots}{Additional parameters supplied to the plot function}
}
\description{
A non-heat map approach to visualizing a water temperature profile useful
for identify temperature trends over time at discrete depths and diagnosing
issues with data.
}
\examples{

exampleFilePath <- system.file('extdata', 'Sparkling.wtr', package="rLakeAnalyzer")
wtr= load.ts(exampleFilePath)
\dontrun{
wtr.lineseries(wtr, ylab = "Temperature C")
}
}
\seealso{
See \code{\link{load.ts}} and \code{\link{wtr.heat.map}}
}
\keyword{hplot}
