% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data.Bfile2MVP}
\alias{MVP.Data.Bfile2MVP}
\title{MVP.Data.Bfile2MVP: To transform plink binary data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018}
\usage{
MVP.Data.Bfile2MVP(
  bfile,
  out = "mvp",
  maxLine = 10000,
  priority = "speed",
  type.geno = "char",
  threads = 0,
  verbose = TRUE
)
}
\arguments{
\item{bfile}{Genotype in binary format (.bed, .bim, .fam)}

\item{out}{the name of output file}

\item{maxLine}{the max number of line to write to big matrix for each loop}

\item{priority}{'memory' or 'speed'}

\item{type.geno}{the type of genotype elements}

\item{threads}{number of thread for transforming}

\item{verbose}{whether to print the reminder}
}
\value{
number of individuals and markers.
Output files:
genotype.desc, genotype.bin: genotype file in bigmemory format
phenotype.phe: ordered phenotype file, same taxa order with genotype file
map.map: SNP information
}
\description{
MVP.Data.Bfile2MVP: To transform plink binary data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018
}
\examples{
\donttest{
bfilePath <- file.path(system.file("extdata", "02_bfile", package = "rMVP"), "mvp")

MVP.Data.Bfile2MVP(bfilePath, tempfile("outfile"), threads=1)
}

}
