% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_neighbor.R
\name{int_neighbor}
\alias{int_neighbor}
\title{Testing marker-by-marker epistasis in neighbor QTL effects}
\usage{
int_neighbor(
  genoprobs,
  pheno,
  smap,
  scale,
  addcovar = NULL,
  addQTL,
  intQTL,
  grouping = rep(1, nrow(smap)),
  response = c("quantitative", "binary"),
  contrasts = NULL
)
}
\arguments{
\item{genoprobs}{Conditional genotype probabilities as taken from \code{qtl::calc.genoprob()}.}

\item{pheno}{A vector of individual phenotypes.}

\item{smap}{A matrix showing a spatial map for individuals. The first and second column include spatial positions along an x-axis and y-axis, respectively.}

\item{scale}{A numeric scalar indicating the maximum spatial distance between a focal individual and neighbors to define neighbor effects.}

\item{addcovar}{An optional matrix including additional non-genetic covariates. It contains no. of individuals x no. of covariates.}

\item{addQTL}{A vector containing marker names that are considered covariates. This argument is necessary for \code{int_neighbor()}, and must match the marker names of \code{gmap}.}

\item{intQTL}{A name of a focal marker to be tested for its epistasis with the other markers in neighbor effects. The marker name must be included by \code{addQTL}.}

\item{grouping}{An optional integer vector assigning each individual to a group. This argument can be used when \code{smap} contains different experimental replicates. Default setting means that all individuals are belong to a single group.}

\item{response}{An optional argument to select trait types. The \code{"quantitative"} or \code{"binary"} calls the \code{"gaussian"} or \code{"binomial"} family in \code{glm()}, respectively.}

\item{contrasts}{An optional vector composed of three TRUE/FALSE values, which represents the presence/absence of specific genotypes as c(TRUE/FALSE, TRUE/FALSE, TRUE/FALSE) = AA, AB, BB. If \code{NULL}, it is compiled from \code{genoprobs} automatically.}
}
\value{
A matrix of LOD scores for neighbor epistasis effects, with the chromosome numbers and positions. The row names correspond to marker names.
\itemize{
\item{\code{chr}} {Chromosome number}
\item{\code{pos}} {Marker position}
\item{\code{LOD_int}} {LOD score for epistasis in neighbor effects between a focal and the other markers}
}
}
\description{
A function to test interaction terms between one focal marker and the other markers across a genome.
}
\details{
This is an optimal function to test two-way interactions between the main neighbor effect of a focal marker given by \code{intQTL} and the others.
All the main neighbor effects are first estimated using \code{eff_neighbor()}, and then a two-way interaction term between the focal marker effect and its counterpart was considered an additional explanatory variable.
LOD score was compared between models with or without the two-way interaction.
}
\examples{
set.seed(1234)
test_map <- qtl::sim.map(len=rep(20,5),n.mar=3,include.x=FALSE)
test_cross <- qtl::sim.cross(test_map,n.ind=50)
test_smap <- cbind(runif(50,1,100),runif(50,1,100))
test_genoprobs <- qtl::calc.genoprob(test_cross,step=2)

test_int <- int_neighbor(genoprobs=test_genoprobs,
                         pheno=test_cross$pheno$phenotype,
                         smap=test_smap,scale=20,
                         addQTL=c("c1_D1M1","c1_D1M2"),intQTL="c1_D1M1"
                         )
plot_nei(test_int, type="int")
}
\seealso{
\code{\link{scan_neighbor}} \code{\link{eff_neighbor}}
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
