% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_results.R
\name{find_results}
\alias{find_results}
\title{Retrieve Specific Fields for Search Results from RCSB PDB}
\usage{
find_results(search_term, field = "citation")
}
\arguments{
\item{search_term}{A string specifying the term to search for in the PDB.}

\item{field}{A string indicating the specific field to retrieve for each search result.
Default is "citation".}
}
\value{
A named list where each element's name is a PDB ID and its value is the information
  for the specified field from the corresponding search result.
}
\description{
This function performs a search in the Protein Data Bank (PDB) using a provided search term
and retrieves information for a specified field (e.g., citation) for each search result.
It relies on `query_search` and `get_info` functions for searching and retrieving detailed information.
}
