% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{reportPopulations}
\alias{reportPopulations}
\title{This is a convenience function to ensure that our population demographics are stored in a data frame
and exists because R's standard functions can collapse single row frames to named vectors.  It requires that
all passed vectors be of the same length}
\usage{
reportPopulations(func_numMuts, func_genotypeID, func_popSizes,
  func_fitnesses, func_births, func_deaths, func_mutants, func_progenitor,
  func_reportMat_colnames = getOption("shape_reportMat_colnames"))
}
\arguments{
\item{func_numMuts}{This is a vector of the number of mutations held within each tracked genotype.}

\item{func_genotypeID}{This is a vector of the unique genotype ID for each tracked population in the community.}

\item{func_popSizes}{This is a vector of the number of individuals for each population of genotypes in the community.}

\item{func_fitnesses}{This is a vector of the fitness for each genotpe being tracked.}

\item{func_births}{This is a vector of the number of births produced by each population in this time step.}

\item{func_deaths}{This is a vector of the number of deaths in each population in this time step.}

\item{func_mutants}{This is a vector of the number of mutants produced by each population in this time step.}

\item{func_progenitor}{This is a vector of character strings expressing any progenitor genotypes which generated a mutant
that fed into each genotype's population in this time step.}

\item{func_reportMat_colnames}{DO NOT MODIFY - This is the vector of character strings to be assigned as the column names.}
}
\value{
A data frame with columns named as per func_reportMat_colnames.
}
\description{
This is a convenience function to ensure that our population demographics are stored in a data frame
and exists because R's standard functions can collapse single row frames to named vectors.  It requires that
all passed vectors be of the same length
}
\examples{
# This returns a data.frame with a standard format
defineSHAPE()
reportPopulations(1:3,2:4,c(10,50,100),rep(1,3),
                 rep(0,3),c(10,10,10),c(1,2,0),c("","0_->_1","2"))
}
