% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.computations.R
\name{precision}
\alias{precision}
\alias{precision.CBrSPDEobj}
\title{Get the precision matrix of CBrSPDEobj objects}
\usage{
precision(object, ...)

\method{precision}{CBrSPDEobj}(
  object,
  user_nu = NULL,
  user_kappa = NULL,
  user_tau = NULL,
  user_m = NULL,
  ...
)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation, 
computed using \code{\link{matern.operators}}}

\item{...}{Currently not used.}

\item{user_nu}{If non-null, update the shape parameter of the covariance function.}

\item{user_kappa}{If non-null, update the range parameter of the covariance function.}

\item{user_tau}{If non-null, update the standard deviation of the covariance function.}

\item{user_m}{If non-null, update the order of the rational approximation, which needs to be a positive integer.}
}
\value{
The precision matrix.
}
\description{
Function to get the precision matrix of a CBrSPDEobj object
}
\examples{
#Compute the covariance-based rational approximation of a 
#Gaussian process with a Matern covariance function on R
kappa <- 10
sigma <- 1
nu <- 0.8

#create mass and stiffness matrices for a FEM discretization
x <- seq(from = 0, to = 1, length.out = 101)
fem <- rSPDE.fem1d(x)

#compute rational approximation of covariance function at 0.5
tau <- sqrt(gamma(nu) / (sigma^2 * kappa^(2*nu) * (4*pi)^(1/2) * gamma(nu+1/2)))
op_cov <- matern.operators(C=fem$C, G=fem$G,nu=nu,
kappa=kappa,sigma=sigma,d=1,m=2)

#Get the precision matrix:
prec_matrix <- precision(op_cov)
}
\seealso{
\code{\link{simulate.CBrSPDEobj}}, \code{\link{matern.operators}}
}
